package com.bycom.versapro.MenuTypes.WordPress.UserInterface;

import static com.bycom.versapro.Serializables.Constant.adMobHelper;
import static com.bycom.versapro.Serializables.Constant.appConfig;

import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.content.res.Configuration;
import android.os.Bundle;
import android.transition.Fade;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.airbnb.lottie.LottieAnimationView;
import com.bycom.versapro.Activities.MainActivity;
import com.bycom.versapro.R;
import com.bycom.versapro.Utils.AdMobHelper;
import com.bycom.versapro.Utils.AppUtil;
import com.bycom.versapro.Utils.PrefUtil;
import com.bycom.versapro.MenuTypes.WordPress.Adapters.WPPostAdapter;

import com.facebook.shimmer.ShimmerFrameLayout;
import com.google.android.gms.ads.admanager.AdManagerAdView;
import com.wordpress.restapi.RESTAPI;
import com.wordpress.restapi.Serializables.WPCategory;
import com.wordpress.restapi.Serializables.WPPost;
import com.wordpress.restapi.CategoriesFetcher;
import com.wordpress.restapi.PostFetcher;
import com.wordpress.restapi.LatestPostsURL;
import com.wordpress.restapi.PostsByCategoryURL;
import com.wordpress.restapi.PostsBySearchURL;
import com.wordpress.restapi.StickyPostsURL;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;


@SuppressLint("SetJavaScriptEnabled")
public class WPPostFragment extends Fragment {
    public static final int TYPE_POSTS_BY_CATEGORY = 1;
    public static final int TYPE_WORDPRESS_HOME = 2;
    public static final int TYPE_POSTS_BY_BOOKMARK = 3;
    public static final int TYPE_POSTS_BY_SEARCH = 4;
    AppCompatActivity activity;
    WPPostAdapter adapter;
    int page = 1;
    boolean maxPageLoaded = false,isLoading = false;
    ShimmerFrameLayout shimmer;
    public int TYPE;
    private String BASE_URL,SEARCH_QUERY;
    private WPCategory CATEGORY;
    CountDownLatch latch;
    LottieAnimationView lottieAnimationView;
    RecyclerView rv_posts;
    TextView tv_error_desc,tv_error_title;
    View ll_error;
    SwipeRefreshLayout swipeRefreshLayout;
    private final ArrayList<WPPost> postArrayList =new ArrayList<>();
    private final ArrayList<WPPost> stickyPostArrayList = new ArrayList<>();
    private final HashMap<Integer, WPCategory> categoryHashMap = new HashMap<>();



    public WPPostFragment(){

    }


    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_wp_post, container, false);
    }


    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        setEnterTransition(new Fade());
        setExitTransition(new Fade());




        if(getArguments() != null){
            TYPE = getArguments().getInt("TYPE");
            BASE_URL = getArguments().getString("BASE_URL");
            CATEGORY = (WPCategory) getArguments().getSerializable("CATEGORY");
            SEARCH_QUERY = getArguments().getString("SEARCH_QUERY");
        }



        activity = (AppCompatActivity) requireActivity();



        shimmer = view.findViewById(R.id.shimmer);
        rv_posts = view.findViewById(R.id.rv_posts);
        tv_error_desc = view.findViewById(R.id.tv_error_desc);
        tv_error_title = view.findViewById(R.id.tv_error_title);
        ll_error = view.findViewById(R.id.ll_error);
        swipeRefreshLayout = view.findViewById(R.id.swipeRefresh);
        lottieAnimationView = view.findViewById(R.id.lottie);


        swipeRefreshLayout.setEnabled(false);

        categoryHashMap.putAll(PrefUtil.getAllCategories(BASE_URL));

        LinearLayoutManager layoutManager = new LinearLayoutManager(activity);
        rv_posts.setLayoutManager(layoutManager);



        rv_posts.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);

                int totalItemCount = layoutManager.getItemCount();
                int lastVisibleItemPosition = layoutManager.findLastVisibleItemPosition();

                if (!isLoading && !maxPageLoaded && (lastVisibleItemPosition > totalItemCount - 4) && TYPE != TYPE_POSTS_BY_BOOKMARK) {
                    isLoading = true;
                    rv_posts.post(() -> loadMorePosts());
                }

            }
        });



        swipeRefreshLayout.setOnRefreshListener(this::fetchData);



        fetchData();


    }





    private void fetchData(){
        adMobHelper.getInterstitialAdManager().showAd(activity);
        maxPageLoaded = false;
        page = 1;
        rv_posts.setVisibility(View.GONE);
        ll_error.setVisibility(View.GONE);
        shimmer.setVisibility(View.VISIBLE);
        shimmer.startShimmer();

        if(TYPE == TYPE_POSTS_BY_CATEGORY) {
            latch = new CountDownLatch(1);
            loadPosts();

        }

        if(TYPE == TYPE_WORDPRESS_HOME){
            latch = new CountDownLatch(3);
            loadStickyPosts();
            loadCategories();
            loadPosts();
        }

        if(TYPE == TYPE_POSTS_BY_BOOKMARK) {
            latch = new CountDownLatch(0);
            postArrayList.clear();
            postArrayList.addAll(PrefUtil.getBookmarkedPosts());

        }

        if(TYPE == TYPE_POSTS_BY_SEARCH){
            latch = new CountDownLatch(1);
            loadPosts();
        }


        new Thread(() -> {
            try {
                latch.await();
                activity.runOnUiThread(this::loadAdapter);
            }catch (Exception ignored){}
        }).start();


    }




    private void loadAdapter() {

        swipeRefreshLayout.setEnabled(true);
        swipeRefreshLayout.setRefreshing(false);
        shimmer.stopShimmer();
        shimmer.setVisibility(View.GONE);

        if(postArrayList.isEmpty()){
            showErrorScreen();
        }else {


            if(postArrayList.size()>1) {
                activity.runOnUiThread(() -> insertAdView(1));
            }



            if (!categoryHashMap.isEmpty() && TYPE == TYPE_WORDPRESS_HOME)
                postArrayList.add(0, new WPPost() {{
                    setType(WPPostAdapter.LAYOUT_CATEGORY_LIST);
                }});
            if (!stickyPostArrayList.isEmpty()) postArrayList.add(0, new WPPost() {{
                setType(WPPostAdapter.LAYOUT_STICKY_LIST);
            }});

            if (TYPE == TYPE_POSTS_BY_CATEGORY) postArrayList.add(0, new WPPost() {{
                setType(WPPostAdapter.LAYOUT_CATEGORY_DETAILS);
            }});



            adapter = new WPPostAdapter(activity, this, stickyPostArrayList, postArrayList, BASE_URL, CATEGORY);
            rv_posts.setAdapter(adapter);
            fadeIn(rv_posts);

        }



    }


    public void fadeIn(View view) {
        view.setAlpha(0f);
        view.setVisibility(View.VISIBLE);
        ObjectAnimator fadeInAnimator = ObjectAnimator.ofFloat(view, "alpha", 0f, 1f);
        fadeInAnimator.setDuration(300);
        fadeInAnimator.start();
    }

    public void showErrorScreen(){





        if(TYPE == TYPE_POSTS_BY_BOOKMARK){


            lottieAnimationView.setAnimation(R.raw.empty);
            tv_error_title.setText(R.string.no_bookmarks);
            tv_error_desc.setText(R.string.no_bookmarks_error_message);
            ll_error.setVisibility(View.VISIBLE);

        }else if(AppUtil.isNoInternet(activity)){

            lottieAnimationView.setAnimation(R.raw.no_internet);
            tv_error_title.setText(R.string.network_error);
            tv_error_desc.setText(R.string.no_internet_error_message);
            ll_error.setVisibility(View.VISIBLE);

        }else {


            lottieAnimationView.setAnimation(R.raw.error);
            tv_error_title.setText(R.string.not_found);
            tv_error_desc.setText(R.string.no_post_error_message);
            ll_error.setVisibility(View.VISIBLE);

        }




    }


    private void showLoader(){
        if(!adapter.posts.isEmpty()){
            WPPost loader = new WPPost();
            loader.setType(WPPostAdapter.ITEM_LOADER);
            int position = adapter.posts.size();
            adapter.posts.add(position,loader);
            adapter.notifyItemInserted(position);
        }
    }

    private void hideLoader(){
        if(!adapter.posts.isEmpty()){
            int position = adapter.posts.size() - 1;
            if(adapter.posts.get(position).getType() == WPPostAdapter.ITEM_LOADER) adapter.posts.remove(position);
            adapter.notifyItemRemoved(position);
        }
    }

    private void loadCategories(){
        CategoriesFetcher.getCategories(BASE_URL, new RESTAPI.CategoriesCallback() {
            @Override
            public void onSuccess(HashMap<Integer, WPCategory> categories) {

                PrefUtil.addCategories(BASE_URL,categories);
                categoryHashMap.clear();
                categoryHashMap.putAll(categories);

                latch.countDown();
            }

            @Override
            public void onFailed(String error) {
                latch.countDown();
            }
        });
    }

    private void loadStickyPosts(){
        PostFetcher.fetchPosts(StickyPostsURL.getStickyPostsURL(BASE_URL),BASE_URL, WPPostAdapter.ITEM_STICKY_POST, new RESTAPI.PostsCallback() {
            @Override
            public void onCompleted(ArrayList<WPPost> posts) {
                stickyPostArrayList.clear();
                stickyPostArrayList.addAll(posts);
                latch.countDown();
            }
            @Override
            public void onFailed(String error) {
                latch.countDown();
            }
        });
    }


    private void loadPosts(){
        String url;
        if(TYPE == TYPE_POSTS_BY_CATEGORY)
            url = PostsByCategoryURL.getPostsByCategoryURL(BASE_URL,CATEGORY.getId(),1);
        else if(TYPE == TYPE_POSTS_BY_SEARCH)
            url = PostsBySearchURL.getPostsBySearchURL(BASE_URL, SEARCH_QUERY,1);
        else url = LatestPostsURL.getLatestPostsURL(BASE_URL,1);


        PostFetcher.fetchPosts(url, BASE_URL, WPPostAdapter.ITEM_POST, new RESTAPI.PostsCallback() {
            @Override
            public void onCompleted(ArrayList<WPPost> posts) {



                postArrayList.clear();
                postArrayList.addAll(posts);


                latch.countDown();
            }

            @Override
            public void onFailed(String error) {
                latch.countDown();

            }
        });
    }


    private void insertAdView(int position){

        adMobHelper.getBannerAdManager().getAnchoredAdView(activity, new AdMobHelper.BannerAdCallback() {
            @Override
            public void onSuccess(AdManagerAdView adManagerAdView) {
                postArrayList.add(position, new WPPost() {{
                    setType(WPPostAdapter.ITEM_BANNER_AD);
                    setAdView(adManagerAdView);
                }});
                adapter.notifyItemInserted(position);

                if(TYPE == TYPE_POSTS_BY_BOOKMARK) {
                    if(postArrayList.size()>position+10){
                        insertAdView(position+10);
                    }
                }
            }

            @Override
            public void onFailed() {

            }
        });

    }

    

    public void handleBackPress(){
        if(activity.getSupportFragmentManager().getBackStackEntryCount()>0)
            activity.getSupportFragmentManager().popBackStack();
        else {
            if(activity instanceof MainActivity mainActivity) {
                mainActivity.closeActivity();
            }else if(activity instanceof WPSearchActivity) activity.finish();
        }
    }

    private void loadMorePosts(){
        showLoader();
        isLoading = true;

        String url;
        if(TYPE == TYPE_POSTS_BY_CATEGORY)
            url = PostsByCategoryURL.getPostsByCategoryURL(BASE_URL,CATEGORY.getId(),page + 1);
        else if(TYPE == TYPE_POSTS_BY_SEARCH)
            url = PostsBySearchURL.getPostsBySearchURL(BASE_URL, SEARCH_QUERY,page + 1);
        else url = LatestPostsURL.getLatestPostsURL(BASE_URL,page + 1);


        PostFetcher.fetchPosts(url, BASE_URL, WPPostAdapter.ITEM_POST,new RESTAPI.PostsCallback() {
            @Override
            public void onCompleted(ArrayList<WPPost> posts) {
                page++;
                isLoading = false;
                activity.runOnUiThread(() -> {
                    hideLoader();

                    if(!posts.isEmpty()) {
                        activity.runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                insertAdView(postArrayList.size());
                            }
                        });
                    }


                    adapter.addMorePosts(posts);


                });

            }

            @Override
            public void onFailed(String error) {

                isLoading = false;
                maxPageLoaded = true;

                activity.runOnUiThread(() -> hideLoader());

            }
        });
    }


    @Override
    public void onDestroy() {
        super.onDestroy();
        if(shimmer!=null) shimmer.stopShimmer();
    }



}